
# if you did not install igraph yet, uncomment and run the following line of code once.
#install.packages("igraph")

library(igraph)


## 1 Reading data
d <- read.csv("data/moreno.csv")

head(d)
moreno <- graph_from_data_frame(d, directed=FALSE)


## Try the following, and interpret the results.
summary(moreno)
diameter(moreno)
V(moreno)
E(moreno)
# play with the 'breaks' parameter.
hist(degree(moreno))




## Plotting networks

plot(moreno)


## Challenge create a nice plot of the Airport data
# - Experiment with different layouts
# - Experiment with node sizes
# - You may want to use some level of transparency for the links

connections <- read.csv("data/USairports_edges.csv")
airports    <- read.csv("data/USairports_vertices.csv")

g <- graph_from_data_frame(connections, vertices = airports)



